<?php

class Prueba {
    /**
     * Cifra un mensaje utilizando AES y luego cifra la clave AES con RSA.
     */
    public function cifrarMensaje($message) {
        $toEncrypt = $message;
        $encrypted = $this->encryptWithAES($toEncrypt);
        $publicKey = $this->obtenerRSAKey();
        $encryptedAesKey = $this->encriptarAES($encrypted['aesKey'], $publicKey);

        error_log("pan:".$encrypted['encrypted']);
        error_log("iv:".$encrypted['ivBase64']);
        error_log("encryptedAesKey:".$encryptedAesKey);
        return [
            'pan' => $encrypted['encrypted'],
            'iv' => $encrypted['ivBase64'],
            'key' => $encryptedAesKey
        ];
    }

    /**
     * Encripta un mensaje con AES.
     */
    private function encryptWithAES($message) {
        $aesKey = openssl_random_pseudo_bytes(32); // 256 bits
        $iv = openssl_random_pseudo_bytes(16); // 128 bits

        $encrypted = openssl_encrypt($message, 'aes-256-cbc', $aesKey, OPENSSL_RAW_DATA, $iv);
        $response = [
            'ivBase64' => base64_encode($iv),
            'aesKey' => base64_encode($aesKey),
            'encrypted' => base64_encode($encrypted)
        ];

        return $response;
    }

    /**
     * Obtiene la clave pública RSA desde un archivo.
     */
    private function obtenerRSAKey() {
        
        try {
            $stream = fopen('/Users/pgcrurom/Downloads/test_key.pem',"r");
            $RSAkeyB64 = stream_get_contents($stream);
            fclose($stream);
            $RSAkey=base64_decode($RSAkeyB64);
            return $RSAkey;
            $pathToPublicKey = '/Users/pgcrurom/Downloads/test_key.pem';
            $publicKey = openssl_pkey_get_public($pathToPublicKey);
            return $publicKey;
        } catch (Exception $e) {
            echo 'Error al leer la llave pública: ',  $e->getMessage(), "\n";
        }
    }

    /**
     * Encripta la clave AES con RSA.
     */
    private function encriptarAES($aesKeyBase64, $publicKey) {
        $aesKey = base64_decode($aesKeyBase64);
        if (!openssl_public_encrypt($aesKey, $encryptedData, $publicKey, OPENSSL_PKCS1_OAEP_PADDING)) {
            throw new Exception('Falló el cifrado RSA');
        }
        return base64_encode($encryptedData);
    }
}

$instanciaPrueba = new Prueba();
try {
    $resultado = $instanciaPrueba->cifrarMensaje('5161520250485597');
    echo 'Resultado: ';
    print_r($resultado);
} catch (Exception $e) {
    echo 'Error: ',  $e->getMessage(), "\n";
}
